<?php require_once('setup.php'); ?>
<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="description" content="<?= $main_name; ?> provides secure online banking, fast digital transactions, savings accounts, business banking, and trusted financial solutions with advanced security and 24/7 access.">

    <meta name="keywords" content="online banking, secure digital banking, internet banking, mobile banking, financial services, savings account, business banking, digital payments, secure transactions, global banking">

    <meta name="author" content="<?= $main_name; ?>">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="index, follow">

    <!-- Open Graph -->
    <meta property="og:title" content="<?= $main_name; ?> | Secure Online Banking Platform">
    <meta property="og:description" content="Experience fast, secure, and reliable digital banking with <?= $main_name; ?>. Manage accounts, transfer funds, and access financial services anytime, anywhere.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?= $main_website ?>">
    <meta property="og:image" content="<?= $main_website ?>/assets/images/og-image.jpg">
    <title><?= $main_name; ?> | Secure Online Banking & Digital Financial Services</title>
    <link href="//fonts.googleapis.com/css2?family=Kumbh+Sans:wght@300;400;700&display=swap" rel="stylesheet">
    <!-- Template CSS -->
    <link rel="stylesheet" href="assets/css/style-starter.css">
    <link rel="icon" type="image/png" href="assets/images/logo.png" />
</head>

<body>
    <?php require_once('preloader.php'); ?>
    <!--header-->
    <?php require_once('header.php'); ?>
    <!--/header-->
    <!-- main-slider -->
    <section class="w3l-main-slider" id="home">
        <div class="companies20-content">
            <div class="owl-one owl-carousel owl-theme">
                <div class="item">
                    <li>
                        <div class="slider-info banner-view bg bg2">
                            <div class="banner-info">
                                <div class="container">
                                    <div class="row">
                                        <div class="col-lg-6 banner-info-bg">
                                            <?php include('translate.php'); ?>
                                            <h6>Online Banking Platform</h6>
                                            <p class="mt-md-4 mt-3">
                                                Online banking is part of the broader context for the move to online banking, where banking services are delivered over the internet. The shift from traditional to digital banking has been gradual and remains ongoing, and is constituted by differing degrees of banking service digitization.
                                            </p>
                                            <a class="btn btn-style btn-primary mt-sm-5 mt-4 mr-2" href="account/"> Online Banking <i class="fa fa-angle-double-right"></i></a>
                                        </div>
                                        <div class="col-lg-5 col-md-8 img offset-lg-1 mt-lg-0 mt-4">
                                            <img src="assets/images/card1.png" alt="img" class="img-fluid radius-image-curve" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                </div>
                <div class="item">
                    <li>
                        <div class="slider-info  banner-view banner-top1 bg bg2">
                            <div class="banner-info">
                                <div class="container">
                                    <div class="row">
                                        <div class="col-lg-6 banner-info-bg">
                                            <?php include('translate.php'); ?>
                                            <h6>2 Years Interest Loan</h6>
                                            <p class="mt-md-4 mt-3">
                                                Get a quick and easy cash loan today. Maybe it's for that purchase you just can't wait for or to score an awesome deal. Or, perhaps you have an unexpected expense and don't want to compromise your lifestyle.
                                            </p>
                                            <a class="btn btn-style btn-outline-light mt-sm-5 mt-4 mr-2" href="personal-loans">Get Loan</a>
                                        </div>
                                        <div class="col-lg-5 col-md-8 img offset-lg-1 mt-lg-0 mt-4">
                                            <img src="assets/images/card2.png" alt="img" class="img-fluid radius-image-curve" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                </div>
                <div class="item">
                    <li>
                        <div class="slider-info banner-view banner-top2 bg bg2">
                            <div class="banner-info">
                                <div class="container">
                                    <div class="row">
                                        <div class="col-lg-6 banner-info-bg">
                                            <?php include('translate.php'); ?>
                                            <h6>Be Innovation Objectives</h6>
                                            <p class="mt-md-4 mt-3">
                                                Innovation objectives are goals to improve things by an order of magnitude. Innovation typically requires experimentation, risk taking and creativity. As such, innovation objectives may involve greater levels of uncertainty than a typical business objective that aims for predictable and quickly obtainable improvements.
                                            </p>
                                            <a class="btn btn-style btn-primary mt-sm-5 mt-4 mr-2" href="personal-insurance"> Discover</a>
                                        </div>
                                        <div class="col-lg-5 col-md-8 img offset-lg-1 mt-lg-0 mt-4">
                                            <img src="assets/images/card3.png" alt="img" class="img-fluid radius-image-curve" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                </div>
                <div class="item">
                    <li>
                        <div class="slider-info banner-view banner-top3 bg bg2">
                            <div class="banner-info">
                                <div class="container">
                                    <div class="row">
                                        <div class="col-lg-6 banner-info-bg">
                                            <?php include('translate.php'); ?>
                                            <h6>Buy Forex With Us</h6>
                                            <p class="mt-md-4 mt-3">
                                                The foreign exchange market is a global decentralized or over-the-counter market for the trading of currencies. This market determines the foreign exchange rate. It includes all aspects of buying, selling and exchanging currencies at current or determined prices.
                                            </p>
                                            <a class="btn btn-style btn-outline-light mt-sm-5 mt-4 mr-2" href="contact">Contact Us</a>
                                        </div>
                                        <div class="col-lg-5 col-md-8 img offset-lg-1 mt-lg-0 mt-4">
                                            <img src="assets/images/card4.png" alt="img" class="img-fluid radius-image-curve" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                </div>
            </div>
        </div>
    </section>
    <!-- /main-slider -->
    <!-- home page block1 -->
    <section id="about" class="home-services pt-lg-0">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6 col-sm-12">
                    <div class="box-wrap">
                        <div class="box-wrap-grid">
                            <div class="icon">
                                <span class="fa fa-cc-mastercard"></span>
                            </div>
                            <div class="info">
                                <p>More than</p>
                                <h4><a href="#!">32,167</a></h4>
                                <h5>Issued Cards</h5>
                            </div>
                        </div>
                        <p class="mt-4">If you are looking for high-quality and reliable banking services. Our Bank card is the best option.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mt-md-0 mt-4">
                    <div class="box-wrap">
                        <div class="box-wrap-grid">
                            <div class="icon">
                                <span class="fa fa-bank"></span>
                            </div>
                            <div class="info">
                                <p>SME Banking</p>
                                <h4><a href="#!">SME</a></h4>
                                <h5>Reliable</h5>
                            </div>
                        </div>
                        <p class="mt-4">We offer a diverse range of solutions, products and services for companies of all sizes.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mt-lg-0 mt-4">
                    <div class="box-wrap">
                        <div class="box-wrap-grid">
                            <div class="icon">
                                <span class="fa fa-laptop"></span>
                            </div>
                            <div class="info">
                                <p>Digital Banking</p>
                                <h4><a href="#!">ONLINE</a></h4>
                                <h5>Secured</h5>
                            </div>
                        </div>
                        <p class="mt-4">Enjoy easy access to your account from any device to meet your financial needs.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- //home page block1 -->
    <!-- about page about section -->
    <section class="w3l-index3" id="about">
        <div class="midd-w3 py-5">
            <div class="container py-lg-5 py-md-3">
                <div class="row">
                    <div class="col-lg-7 mb-lg-0 mb-md-5 mb-4 align-self">
                        <h6>BOLD DESING AND BEYOUND</h6>
                        <h3 class="title-left mx-0">Helping small businesses like yours</h3>
                        <p class="mt-md-4 mt-3">Some businesses are inherently more profitable than others. This can be due to expenses and overhead being low or the business charging a lot for its services or products. Still, all businesses, no matter how profitable they are, can be a challenge getting started. If you are thinking of starting a small business, you might care about potential profits. While your skills as an entrepreneur and the quality of your business idea certainly influence what you will earn, so does the industry in which you operate. In fact, as figures from business data aggregator show small business profitability varies a lot across industries.</p>
                    </div>
                    <div class="col-lg-5">
                        <div class="position-relative">
                            <img src="assets/images/about.jpg" alt="" class="radius-image img-fluid">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- //about page about section -->
    <!-- /mobile section --->
    <section class="w3l-mobile-content-6 py-5">
        <div class="mobile-info py-lg-5 py-md-4 py-2">
            <!-- /mobile-info-->
            <div class="container">
                <h6 class="title-small text-center">The Best Banking Choice</h6>
                <h3 class="title-big mb-5 text-center">OUR SERVICES</h3>
                <div class="row mobile-info-inn mx-lg-0">
                    <div class="col-lg-4 mobile-right text-right">
                        <div class="row mobile-right-grids mb-lg-5 mb-4">
                            <div class="col-10 mobile-right-info">
                                <h6><a href="#!">Personal Loans</a></h6>
                                <p><?= $main_name; ?> makes installment loans at all of our full-service bank locations, with friendly, helpful loan officers.</p>
                            </div>
                            <div class="col-2 mobile-right-icon">
                                <div class="mobile-icon">
                                    <span class="fa fa-bar-chart"></span>
                                </div>
                            </div>
                        </div>
                        <div class="row mobile-right-grids mb-lg-5 mb-4">
                            <div class="col-10 mobile-right-info">
                                <h6><a href="#!">Easy & Fast Answer</a></h6>
                                <p>A whole page was dedicated to some of your Frequently Asked Questions - FAQs</p>
                            </div>
                            <div class="col-2 mobile-right-icon">
                                <div class="mobile-icon">
                                    <span class="fa fa-question"></span>
                                </div>
                            </div>
                        </div>
                        <div class="row mobile-right-grids">
                            <div class="col-10 mobile-right-info">
                                <h6><a href="#!">Less Papers Work</a></h6>
                                <p>Open a Savings, Checking, Residence and Non-Residence Account, (Sign up Required) Get Involved.</p>
                            </div>
                            <div class="col-2 mobile-right-icon">
                                <div class="mobile-icon">
                                    <span class="fa fa-edit"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 mobile-left px-lg-5">
                        <img src="assets/images/mobile.png" class="img-fluid radius-image" alt="">
                    </div>
                    <div class="col-lg-4 mobile-right">
                        <div class="row mobile-right-grids mb-lg-5 mb-4">
                            <div class="col-2 mobile-right-icon">
                                <div class="mobile-icon">
                                    <span class="fa fa-user"></span>
                                </div>
                            </div>
                            <div class="col-10 mobile-right-info">
                                <h6><a href="#!">Good Investment</a></h6>
                                <p>If you're not sure the best place to park your money for the long-term, we have 7 investment options that will put your money to work.</p>
                            </div>
                        </div>
                        <div class="row mobile-right-grids mb-lg-5 mb-4">
                            <div class="col-2 mobile-right-icon">
                                <div class="mobile-icon">
                                    <span class="fa fa-user"></span>
                                </div>
                            </div>
                            <div class="col-10 mobile-right-info">
                                <h6><a href="#!">Easy Account Setup</a></h6>
                                <p>Register your personal profile online to begin using our services. Registered clients can edit the account settings in 2 clicks.</p>
                            </div>
                        </div>
                        <div class="row mobile-right-grids">
                            <div class="col-2 mobile-right-icon">
                                <div class="mobile-icon">
                                    <span class="fa fa-support"></span>
                                </div>
                            </div>
                            <div class="col-10 mobile-right-info">
                                <h6><a href="#!">24/7 support</a></h6>
                                <p>Support team is always ready to help you solve any banking issues</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- //mobile-info-->
        </div>
    </section>
    <!-- //mobile section --->
    <!-- /bottom-grids-->
    <section class="w3l-bottom-grids-6 py-5" id="advantages">
        <div class="container py-lg-5 py-md-4 py-2">
            <div class="grids-area-hny main-cont-wthree-fea row pt-3">
                <div class="col-lg-4 ceo-text mb-lg-0 mb-4">
                    <div class="">
                        <span class="fa fa-quote-left"></span>
                        <p>Generally, the goal is to keep funds invested, reinvest income and capital gains, and have these compound for as long as possible.</p>
                        <div class="author align-items-center mt-4 mb-1">
                            <div class="img-circle" style="border: 2px solid #7b59d0;">
                                <img src="assets/images/logo.png" class="mr-3 img-fluid" alt="...">
                            </div>
                            <div class="author-info">
                                <a href="#!">Accumulation goals</a> <br> <span class="meta-value">BOLD DESIGN AND BEYOND </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 grids-feature">
                    <div class="area-box">
                        <h4><a href="#!" class="title-head">Secure Financial Services</a></h4>
                        <p>Whether you're facing retirement or looking to better understand certain investment ideas, we can help you address your most pressing money questions.</p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 grids-feature mt-md-0 mt-4">
                    <div class="area-box">
                        <h4><a href="#!" class="title-head">Agriculture Business </a></h4>
                        <p>A selection of services targeted at the Agriculture sector, diverse range of solutions, products and services for companies of all sizes to meet your financial needs..</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- //bottom-grids-->
    <!-- section -->
    <section class="w3l-statistics" id="statistical">
        <div class="midd-w3 py-5">
            <div class="container py-lg-5 py-md-3 py-2">
                <h6 class="title-small text-center">Banking statistics.</h6>
                <h3 class="title-big mb-md-5 mb-4 text-center">Statistical Information</h3>
                <div class="row">
                    <div class="col-lg-4 align-self w3l-progressblock pr-lg-4">
                        <p class="mb-4">Our financial services deeply rely on certain banking procedures that have been
                            perfected over
                            the years and helped us get prestigious awards.</p>
                        <div class="progress-info info1">
                            <h6 class="progress-tittle">Financial consulting <span class="">80%</span></h6>
                            <div class="progress">
                                <div class="progress-bar progress-bar-striped" role="progressbar" style="width: 80%" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100">
                                </div>
                            </div>
                        </div>
                        <div class="progress-info info2">
                            <h6 class="progress-tittle">Online Bank cards <span class="">95%</span>
                            </h6>
                            <div class="progress">
                                <div class="progress-bar progress-bar-striped" role="progressbar" style="width: 95%" aria-valuenow="95" aria-valuemin="0" aria-valuemax="100">
                                </div>
                            </div>
                        </div>
                        <div class="progress-info info3">
                            <h6 class="progress-tittle">Online reporting <span class="">90%</span></h6>
                            <div class="progress">
                                <div class="progress-bar progress-bar-striped" role="progressbar" style="width: 90%" aria-valuenow="95" aria-valuemin="0" aria-valuemax="100">
                                </div>
                            </div>
                        </div>
                        <div class="progress-info info4">
                            <h6 class="progress-tittle">Online banking <span class="">75%</span></h6>
                            <div class="progress">
                                <div class="progress-bar progress-bar-striped" role="progressbar" style="width: 75%" aria-valuenow="95" aria-valuemin="0" aria-valuemax="100">
                                </div>
                            </div>
                        </div>
                        <div class="progress-info info2 mb-0">
                            <h6 class="progress-tittle">24/7 support <span class="">95%</span></h6>
                            <div class="progress">
                                <div class="progress-bar progress-bar-striped" role="progressbar" style="width: 95%" aria-valuenow="95" aria-valuemin="0" aria-valuemax="100">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-lg-0 mt-5 align-self">
                        <div class="position-relative">
                            <div class="progress-circles">
                                <div class="circle1">
                                    <div id="progress" data-dimension="170" data-text="65%" data-fontsize="30" data-percent="65" data-fgcolor="#1d0d44" data-bgcolor="#eee" data-width="15" data-bordersize="5" data-animationstep="2"></div>
                                    <h4>Economy</h4>
                                </div>
                                <div class="circle1">
                                    <div id="progress1" data-dimension="170" data-text="75%" data-fontsize="30" data-percent="75" data-fgcolor="#1d0d44" data-bgcolor="#eee" data-width="15" data-bordersize="5" data-animationstep="2"></div>
                                    <h4>Stability</h4>
                                </div>
                                <div class="circle1">
                                    <div id="progress2" data-dimension="170" data-text="90%" data-fontsize="30" data-percent="90" data-fgcolor="#1d0d44" data-bgcolor="#eee" data-width="15" data-bordersize="5" data-animationstep="2"></div>
                                    <h4>Guarantee</h4>
                                </div>
                                <div class="circle1">
                                    <div id="progress3" data-dimension="170" data-text="100%" data-fontsize="30" data-percent="80" data-fgcolor="#1d0d44" data-bgcolor="#eee" data-width="15" data-bordersize="5" data-animationstep="2"></div>
                                    <h4>Resources</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 mt-lg-0 mt-md-5 mt-4">
                        <img src="assets/images/stats.jpg" alt="" class="radius-image img-fluid">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- // about section -->
    <!-- forms -->
    <section class="w3l-forms-9 py-5">
        <div class="container py-lg-3">
            <div class="row align-items-center">
                <div class="main-midd col-lg-7 text-lg-right">
                    <h4 class="title-big">Are you in need for a loan? </h4>
                </div>
                <div class="col-lg-5 mt-lg-0 mt-4">
                    <a class="btn btn-style btn-dark" href="contact"> Contact Us</a>
                </div>
            </div>
        </div>
    </section>
    <!-- //forms -->
    <div class="w3l-ordercard py-5">
        <div class="container py-lg-5 py-md-4 py-2">
            <h6 class="title-small text-center">EASY PROFILE ACCESS</h6>
            <h3 class="title-big mb-5 text-center">Account Setup Process</h3>
            <div class="row text-center">
                <div class="col-lg-3 col-sm-6">
                    <div class="work-grids">
                        <div class="icon">
                            <span class="fa fa-sign-in"></span>
                        </div>
                        <div class="content">
                            <h4 class="title">Online Registration</h4>
                            <p class="desc">Navigate Your way to "Online Banking" and click on the register section</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 mt-sm-0 mt-5">
                    <div class="work-grids">
                        <div class="icon">
                            <span class="fa fa-file-text-o"></span>
                        </div>
                        <div class="content">
                            <h4 class="title">Filling Out a Form</h4>
                            <p class="desc">Kindly fill out the registration form with the appropriate details and proceed </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 mt-lg-0 mt-5">
                    <div class="work-grids">
                        <div class="icon">
                            <span class="fa fa-unlock"></span>
                        </div>
                        <div class="content">
                            <h4 class="title">Awaiting Verification</h4>
                            <p class="desc">After completing the registration form, your profile would be pending approval.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 mt-lg-0 mt-5">
                    <div class="work-grids">
                        <div class="icon">
                            <span class="fa fa-check"></span>
                        </div>
                        <div class="content">
                            <h4 class="title">All Done</h4>
                            <p class="desc">Once your account is approved, your account details would be sent directly to your mail.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- footer -->
    <?php require_once('footer.php'); ?>
    <!-- //footer -->
    <!--  javascripts file here -->
    <script src="assets/js/jquery-3.3.1.min.js"></script>
    <script src="assets/js/theme-change.js"></script> <!-- //light and dark mode switch js -->
    <script src="assets/js/circles.js"></script>
    <!-- stats number counter-->
    <script src="assets/js/jquery.waypoints.min.js"></script>
    <script src="assets/js/jquery.countup.js"></script>
    <script>
        $('.counter').countUp();
    </script>
    <!-- //stats number counter -->
    <!-- owl carousel -->
    <script src="assets/js/owl.carousel.js"></script>
    <!-- script for banner slider-->
    <script>
        $(document).ready(function() {
            $('.owl-one').owlCarousel({
                loop: true,
                margin: 0,
                nav: false,
                responsiveClass: true,
                autoplay: true,
                autoplayTimeout: 5000,
                autoplaySpeed: 1000,
                autoplayHoverPause: false,
                responsive: {
                    0: {
                        items: 1
                    },
                    480: {
                        items: 1
                    },
                    667: {
                        items: 1
                    },
                    1000: {
                        items: 1
                    }
                }
            })
        })
    </script>
    <!-- //script -->
    <!-- owl carousel -->
    <!-- script for tesimonials carousel slider -->
    <script>
        $(document).ready(function() {
            $("#owl-demo2").owlCarousel({
                loop: true,
                margin: 20,
                nav: false,
                responsiveClass: true,
                responsive: {
                    0: {
                        items: 1,
                        nav: false
                    },
                    1000: {
                        items: 1,
                        nav: false,
                        loop: false
                    }
                }
            })
        })
    </script>
    <!-- //script for tesimonials carousel slider -->
    <!-- disable body scroll which navbar is in active -->
    <script>
        $(function() {
            $('.navbar-toggler').click(function() {
                $('body').toggleClass('noscroll');
            })
        });
    </script>
    <!-- disable body scroll which navbar is in active -->
    <!--/MENU-JS-->
    <script>
        $(window).on("scroll", function() {
            var scroll = $(window).scrollTop();

            if (scroll >= 80) {
                $("#site-header").addClass("nav-fixed");
            } else {
                $("#site-header").removeClass("nav-fixed");
            }
        });

        //Main navigation Active Class Add Remove
        $(".navbar-toggler").on("click", function() {
            $("header").toggleClass("active");
        });
        $(document).on("ready", function() {
            if ($(window).width() > 991) {
                $("header").removeClass("active");
            }
            $(window).on("resize", function() {
                if ($(window).width() > 991) {
                    $("header").removeClass("active");
                }
            });
        });
    </script>
    <!--//MENU-JS-->
    <script src="assets/js/bootstrap.min.js"></script><!-- //bootstrap js -->
    <?php include('chat.php'); ?>
</body>

</html>
