<?php ob_start();
include("security.php"); ?>
<?php require_once('../setup.php'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title><?= $main_capital_name; ?></title>
  <!-- plugins:css -->
  <link rel="stylesheet" href="vendors/feather/feather.css">
  <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
  <link rel="stylesheet" href="vendors/css/vendor.bundle.base.css">
  <!-- endinject -->
  <!-- Plugin css for this page -->
  <link rel="stylesheet" href="vendors/datatables.net-bs4/dataTables.bootstrap4.css">
  <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
  <link rel="stylesheet" type="text/css" href="js/select.dataTables.min.css">
  <link rel="stylesheet" href="vendors/mdi/css/materialdesignicons.min.css">
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="css/vertical-layout-light/style.css">
  <!-- endinject -->
  <link rel="shortcut icon" href="../assets/images/logo.png" />
</head>

<body>
  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php include('topbar.php'); ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php include('nav.php'); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="row">
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">International Bank Transfer</h4>
                  <p class="card-description">
                    Dear, <?= $dbfirst_name; ?><br>Your IP Address <b><?= $_SERVER['REMOTE_ADDR']; ?></b> has been logged on our server at <b><?= date('d M Y'); ?></b> to monitor money laundering.
                  </p>
                  <p class="card-description">
                    Please, carefully fill required details below to transfer funds.
                  </p>
                  <?php
                  if (isset($_POST['transfer'])) {
                    require_once("conn.php");
                    $from_acc = $dbfirst_name . ':' . $dbaccount_number;
                    $amount = mysqli_real_escape_string($dbconfig, $_POST['amount']);
                    $account_number = mysqli_real_escape_string($dbconfig, $_POST['account_number']);
                    $account_name = mysqli_real_escape_string($dbconfig, $_POST['account_name']);
                    $bank = mysqli_real_escape_string($dbconfig, $_POST['bank']);
                    $address = mysqli_real_escape_string($dbconfig, $_POST['address']);
                    $swift_code = mysqli_real_escape_string($dbconfig, $_POST['swift_code']);
                    $rtn = mysqli_real_escape_string($dbconfig, $_POST['rtn']);
                    $remarks = mysqli_real_escape_string($dbconfig, $_POST['remarks']);
                    $transaction_id = sha1(rand(1111, 9999) . date('ymdhis'));
                    $date = date('d-m-Y H:i');

                    $transaction_id_coded = base64_encode($transaction_id);

                    if ($amount >= $dbbalance) {
                      echo '<div align="center" class=" alert alert-danger">
                              <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                              <strong>Warning!</strong> Insufficient Funds.
                            </div>';
                    } else {
                      $sql = "INSERT INTO transactions (user_id, from_acc, amount, account_number, account_name, bank, address, swift_code, rtn, remark, transaction_id, tag, date) VALUES ('$dbid', '$from_acc', '$amount', '$account_number', '$account_name', '$bank', '$address', '$swift_code', '$rtn', '$remarks', '$transaction_id', 'others', '$date')";
                      if ($dbconfig->query($sql) === true) {
                        header("Refresh: 15; url=verify-wire-transfer?i=$transaction_id_coded");
                        echo '
                            <div class="progress" style="height:35px; background-color: #333;">
                              <div class="progress-bar progress-bar-striped active" style="font-size: 15px; font-weight: bold;" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                          ';
                      } else {
                        echo "Error: " . $sql . "<br>" . $dbconfig->error;
                      }
                    }
                  }
                  ?>
                  <form class="forms-sample" action="" method="POST">
                    <div class="form-group">
                      <label for="exampleInputUsername1">From<sup style="color: red;">*</sup></label>
                      <input style="text-transform: capitalize;" type="text" class="form-control" id="exampleInputUsername1" value="<?= $dbfirst_name . ' - ' . $dbaccount_number . ' - [' . $dbcurrency . '' . number_format($dbbalance, 2) . ']'; ?>" readonly required>
                    </div>
                    <div class="form-group">
                      <label for="exampleInputUsername1">Amount<sup style="color: red;">*</sup></label>
                      <input type="number" class="form-control" id="exampleInputUsername1" placeholder="eg. 30000" value="<?php if (isset($_POST['amount'])) {
                                                                                                                            echo $_POST['amount'];
                                                                                                                          } ?>" name="amount" maxlength="100" required>
                    </div>
                    <div class="form-group">
                      <label for="exampleInputUsername1">Receiver's Bank Account Number<sup style="color: red;">*</sup></label>
                      <input type="number" class="form-control" id="exampleInputUsername1" placeholder="eg. 4761387494" value="<?php if (isset($_POST['account_number'])) {
                                                                                                                                  echo $_POST['account_number'];
                                                                                                                                } ?>" name="account_number" maxlength="10" required>
                    </div>
                    <div class="form-group">
                      <label for="exampleInputUsername1">Receiver's Name<sup style="color: red;">*</sup></label>
                      <input type="text" class="form-control" id="exampleInputUsername1" placeholder="eg. Johnson Peters" value="<?php if (isset($_POST['account_name'])) {
                                                                                                                                    echo $_POST['account_name'];
                                                                                                                                  } ?>" name="account_name" maxlength="100" required>
                    </div>
                    <div class="form-group">
                      <label for="exampleInputUsername1">Receiver's Bank<sup style="color: red;">*</sup></label>
                      <input type="text" class="form-control" id="exampleInputUsername1" placeholder="eg. SunTrust Bank" value="<?php if (isset($_POST['bank'])) {
                                                                                                                                  echo $_POST['bank'];
                                                                                                                                } ?>" name="bank" maxlength="100" required>
                    </div>
                    <div class="form-group">
                      <label for="exampleInputUsername1">Receiver's Bank Address<sup style="color: red;">*</sup></label>
                      <input type="text" class="form-control" id="exampleInputUsername1" placeholder="eg. New York, NY, USA" value="<?php if (isset($_POST['address'])) {
                                                                                                                                      echo $_POST['address'];
                                                                                                                                    } ?>" name="address" maxlength="200" required>
                    </div>
                    <div class="form-group">
                      <label for="exampleInputUsername1">IFSC/Swift Code<sup style="color: red;">*</sup></label>
                      <input type="text" class="form-control" id="exampleInputUsername1" placeholder="eg. SNTRUS3A" value="<?php if (isset($_POST['swift_code'])) {
                                                                                                                              echo $_POST['swift_code'];
                                                                                                                            } ?>" name="swift_code" maxlength="100" required>
                    </div>
                    <div class="form-group">
                      <label for="exampleInputUsername1">Routing Transit Number (RTN)<sup style="color: red;">*</sup></label>
                      <input type="text" class="form-control" id="exampleInputUsername1" placeholder="eg. 061000104" value="<?php if (isset($_POST['rtn'])) {
                                                                                                                              echo $_POST['rtn'];
                                                                                                                            } ?>" name="rtn" maxlength="100" required>
                    </div>
                    <div class="form-group">
                      <label for="exampleInputUsername1">Remarks<sup style="color: red;">*</sup></label>
                      <textarea type="text" class="form-control" id="exampleInputUsername1" placeholder="eg. Purchase Upfront" name="remarks" maxlength="100" required><?php if (isset($_POST['remarks'])) {
                                                                                                                                                                          echo $_POST['remarks'];
                                                                                                                                                                        } ?></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary mr-2" name="transfer">Verify & Transfer</button>
                    <a href="dashboard" class="btn btn-light">Cancel</a>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <footer class="footer">
          <?php
          include('footer.php');
          ?>
        </footer>
        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->

  <!-- Progress Bar -->
  <script>
    var progressBar = document.getElementsByClassName('progress-bar')[0];
    var progress = 0;
    startProgress();

    function startProgress() {
      setTimeout(() => {
        progressBar.innerHTML = '<span>...</span>';
        progressBar.style.width = '10%';
        progressBar.style.height = '40px';
        progressBar.classList.add('bg-warning')
      }, 500);
      setTimeout(() => {
        progressBar.innerHTML = '<span>Securing</span>';
        progressBar.style.width = '15%';
        progressBar.style.height = '40px';
        progressBar.classList.remove('bg-warning')
        progressBar.classList.add('bg-info')
      }, 4000);
      setTimeout(() => {
        progressBar.innerHTML = '<span>Initiating</span>';
        progressBar.style.width = '30%';
        progressBar.style.height = '40px';
        progressBar.classList.remove('bg-info')
        progressBar.classList.add('bg-primary')
      }, 7000);
      setTimeout(() => {
        progressBar.innerHTML = '<span><i>Authenticating...</i></span>';
        progressBar.style.width = '40%';
        progressBar.style.height = '40px';
        progressBar.classList.remove('bg-primary')
        progressBar.classList.add('bg-success')
      }, 10000);
    }
  </script>

  <!-- plugins:js -->
  <script src="vendors/js/vendor.bundle.base.js"></script>
  <!-- endinject -->
  <!-- Plugin js for this page -->
  <script src="vendors/chart.js/Chart.min.js"></script>
  <script src="vendors/datatables.net/jquery.dataTables.js"></script>
  <script src="vendors/datatables.net-bs4/dataTables.bootstrap4.js"></script>
  <script src="js/dataTables.select.min.js"></script>

  <!-- End plugin js for this page -->
  <!-- inject:js -->
  <script src="js/off-canvas.js"></script>
  <script src="js/hoverable-collapse.js"></script>
  <script src="js/template.js"></script>
  <script src="js/settings.js"></script>
  <script src="js/todolist.js"></script>
  <!-- endinject -->
  <!-- Custom js for this page-->
  <script src="js/dashboard.js"></script>
  <script src="js/Chart.roundedBarCharts.js"></script>
  <!-- End custom js for this page-->
  <?php include('../chat.php'); ?>
</body>

</html>
