<?php include("security.php"); ?>
<?php require_once('../setup.php'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title><?= $main_capital_name; ?></title>
  <!-- plugins:css -->
  <link rel="stylesheet" href="vendors/feather/feather.css">
  <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
  <link rel="stylesheet" href="vendors/css/vendor.bundle.base.css">
  <!-- endinject -->
  <!-- Plugin css for this page -->
  <link rel="stylesheet" href="vendors/datatables.net-bs4/dataTables.bootstrap4.css">
  <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
  <link rel="stylesheet" type="text/css" href="js/select.dataTables.min.css">
  <link rel="stylesheet" href="vendors/mdi/css/materialdesignicons.min.css">
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="css/vertical-layout-light/style.css">
  <!-- endinject -->
  <link rel="shortcut icon" href="../assets/images/logo.png" />
</head>

<body>
  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php include('topbar.php'); ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php include('nav.php'); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="row">
            <div class="col-md-12 grid-margin">
              <div class="row">
                <div class="col-12 mb-4 mb-xl-0">
                  <h3 class="font-weight-bold" style="text-transform: capitalize;">Welcome <?= $dbusername; ?></h3>
                  <h6 class="font-weight-normal mb-0">All systems are running smoothly!</h6>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-12">
              <?php
              if (isset($_GET['c'])) {
                echo '<div align="center" class="alert alert-warning alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><i class="mdi mdi-glasses"></i>Your Card is Currently Unavailable at The Moment.<br><b>Kindly check back later.</b></div>';
              }
              ?>
            </div>
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card tale-bg">
                <div class="card-people mt-auto">
                  <img src="images/dashboard/people.svg" alt="people">
                  <div class="weather-info">
                    <div class="d-flex">
                      <div>
                        <h2 class="mb-0 font-weight-normal"><i class=" icon-sun mr-2"></i><sup>|</sup></h2>
                      </div>
                      <div class="ml-2">
                        <h4 class="location font-weight-normal"><?= $dbfirst_name . ' ' . $dblast_name; ?></h4>
                        <h6 class="font-weight-normal"><?= $dbcountry; ?></h6>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-6 grid-margin transparent">
              <div class="row">
                <div class="col-md-12 mb-4 stretch-card transparent">
                  <div class="card data-icon-card-primary">
                    <div class="card-body">
                      <p class="card-title text-white">Your Current Balance</p>
                      <div class="row">
                        <div class="col-8 text-white">
                          <h3><?= $dbcurrency; ?><?= number_format($dbbalance, 2); ?></h3>
                          <p class="text-white font-weight-500 mb-0">Available Balance <b><?= $dbcurrency; ?><?= number_format($dbbalance, 2); ?></b></p>
                          <hr>
                          <h6 class="text-white mb-0" style="text-transform: capitalize;"><i class="mdi mdi-account-check"></i> Acc Status <b class="text-success"><?= $dbstatus; ?></b></h6>
                        </div>
                        <div class="col-4 background-icon">
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-md-6 mb-4 mb-lg-0 stretch-card transparent">
                  <div class="card card-light-blue">
                    <div class="card-body">
                      <p class="mb-4">Account N<u>o</u></p>
                      <p class="fs-30 mb-2" style="font-size:1.7em;"><?= $dbaccount_number; ?></p>
                      <p>Savings Account</p>
                    </div>
                  </div>
                </div>
                <div class="col-md-6 stretch-card transparent">
                  <div class="card card-dark-blue">
                    <div class="card-body">
                      <p class="mb-4"><?= $dbemail; ?></p>
                      <p class="fs-30 mb-2" style="text-transform: capitalize; font-size:1.7em;">A/C User Profile</p>
                      <a href="profile"><button class="btn btn-warning btn-sm">View Profile</button></a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <p class="card-title"><i class="mdi mdi-library-books menu-icon"></i> Recent Transactions</p>
                  <div class="row">
                    <div class="col-12">
                      <div class="table-responsive">
                        <table class="table table-striped table-hover" style="width:100%">
                          <thead>
                            <tr>
                              <th>&nbsp;</th>
                              <th>Acc Name</th>
                              <th>Amount</th>
                              <th>Bank Name</th>
                              <th>Date</th>
                              <th>Type</th>
                              <th>Status</th>
                              <th></th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php
                            require_once("conn.php");
                            $query = mysqli_query($dbconfig, ("SELECT * FROM transactions WHERE user_id= '$dbid' ORDER BY id DESC LIMIT 5"));
                            if (mysqli_num_rows($query) > 0) {
                              while ($row = $query->fetch_assoc()) {

                                //Status Function
                                if ($row['status'] == 'pending') {
                                  $new_status = '<span style="color: orange;">' . $row['status'] . '</span>';
                                } elseif ($row['status'] == 'approved') {
                                  $new_status = '<span style="color: green;">' . $row['status'] . '</span>';
                                } elseif ($row['status'] == 'canceled') {
                                  $new_status = '<span style="color: red;">' . $row['status'] . '</span>';
                                }

                                //Type Function
                                if ($row['type'] == 'Credit') {
                                  $new_type = '<span style="color: green;">' . $row['type'] . '</span>';
                                } elseif ($row['type'] == 'Debit') {
                                  $new_type = '<span style="color: red;">' . $row['type'] . '</span>';
                                }

                                //Link
                                if ($row['tag'] == 'same' and $row['status'] == 'pending') {
                                  $new_link = 'verify-transfer?i=' . base64_encode($row['transaction_id']);
                                } elseif ($row['tag'] == 'others' and empty($row['cot_code']) and $row['status'] == 'pending') {
                                  $new_link = 'verify-wire-transfer?i=' . base64_encode($row['transaction_id']);
                                } elseif ($row['tag'] == 'others' and empty($row['vat_code']) and $row['status'] == 'pending') {
                                  $new_link = 'verify-vat?i=' . base64_encode($row['transaction_id']);
                                }

                                //Button
                                if ($row['status'] == 'pending') {
                                  $new_button = '<a href="' . $new_link . '"><button class="btn btn-sm btn-warning">Continue</button></a>';
                                } else {
                                  $new_button = '';
                                }
                                echo '
                                <tr>
                                  <td><i class="mdi mdi-arrow-right menu-icon"></i></td>
                                  <td>' . $row['account_name'] . '</td>
                                  <td>'.$dbcurrency.''.number_format($row['amount'], 2) . '</td>
                                  <td>' . $row['bank'] . '</td>
                                  <td>' . $row['date'] . '</td>
                                  <td>' . $new_type . '</td>
                                  <td style=" text-transform: capitalize;">' . $new_status . '</td>
                                  <td><a href="view-transaction?i=' . base64_encode($row['transaction_id']) . '"><button class="btn btn-sm btn-primary">View Transaction</button></a></td>
                                  <td>' . $new_button . '</td>
                                </tr>';
                              }
                            } else {
                              echo '
                                <tr>
                                  <td align="center" colspan="9">
                                    <h3 class="font-weight-bold"> No Recent Transactions</h3>
                                  </td>
                                </tr>';
                            }
                            ?>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <footer class="footer">
          <?php
          include('footer.php');
          ?>
        </footer>
        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->

  <!-- plugins:js -->
  <script src="vendors/js/vendor.bundle.base.js"></script>
  <!-- endinject -->
  <!-- Plugin js for this page -->
  <script src="vendors/chart.js/Chart.min.js"></script>
  <script src="vendors/datatables.net/jquery.dataTables.js"></script>
  <script src="vendors/datatables.net-bs4/dataTables.bootstrap4.js"></script>
  <script src="js/dataTables.select.min.js"></script>

  <!-- End plugin js for this page -->
  <!-- inject:js -->
  <script src="js/off-canvas.js"></script>
  <script src="js/hoverable-collapse.js"></script>
  <script src="js/template.js"></script>
  <script src="js/settings.js"></script>
  <script src="js/todolist.js"></script>
  <!-- endinject -->
  <!-- Custom js for this page-->
  <script src="js/dashboard.js"></script>
  <script src="js/Chart.roundedBarCharts.js"></script>
  <!-- End custom js for this page-->
  <?php include('../chat.php'); ?>
</body>

</html>
