<?php require_once('../../setup.php'); ?>
<?php
session_start();
ob_start();
if (!isset($_SESSION['hash'])) {
  header("Location: ../");
  exit();
} else {
  $hash = $_SESSION['hash'];
}
?>
<!DOCTYPE html>
<html lang="en">

<head>

  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">

  <title><?= $main_name; ?></title>

  <!-- Custom fonts for this template-->
  <link rel="shortcut icon" href="../../assets/images/logo.png" />
  <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
  <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

  <!-- Custom styles for this template -->
  <link href="css/sb-admin-2.min.css" rel="stylesheet">

  <!-- Custom styles for this page -->
  <link href="vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">

</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <!-- Sidebar -->
    <?php include('admin_nav.php'); ?>
    <!-- End of Sidebar -->

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar -->
        <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">&nbsp;</nav>
        <!-- End of Topbar -->

        <!-- Begin Page Content -->
        <div class="container-fluid">

          <!-- Page Heading -->
          <h1 class="h3 mb-2 text-primary"><i class="fa fa-home"></i> Admin Dashboard</h1>

          <!-- DataTales Example -->
          <div class="card shadow mb-4">
            <div class="card-header py-3">
              <h6 class="m-0 font-weight-bold text-primary"><i class="fa fa-users"></i> Record of All Accounts</h6>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <?php

                if (isset($_POST['update_pass'])) {
                  require_once("../conn.php");

                  $pass = $_POST['pass'];
                  $sql = "UPDATE admin_pass SET password='$pass'";

                  if ($dbconfig->query($sql) === TRUE) {
                    header("Refresh: 2; url=florence");
                    echo '<div align="center" class="alert alert-success"><i class="fa fa-check"></i>&nbsp;&nbsp;<b>Administrator Password</b> was changed successfully...</div>';
                  }
                }

                ?>
                <table class="table table-bordered table-sm" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th></th>
                      <th>Full Name</th>
                      <th>Account No</th>
                      <th>Email</th>
                      <th>Phone</th>
                      <th>Balance</th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    require_once("../conn.php");

                    $sql = "SELECT * FROM accounts ORDER BY id DESC";
                    $result = $dbconfig->query($sql);

                    if ($result->num_rows > 0) {
                      // output data of each row
                      while ($row = $result->fetch_assoc()) {
                        echo '
                          <tr>
                            <td> <i class="fa fa-angle-right"></i> </td>
                            <td>' . $row['first_name'] . ' ' .$row['middle_initial']. ' ' .$row['last_name']. '</td>
                            <td>' . $row['account_number'] . '</td>
                            <td>' . $row['email'] . '</td>
                            <td>' . $row['phone'] . '</td>
                            <td>$' . number_format($row['balance'], 2) . '</td>
                            <td align="center"><a href="admin_edit?e=' . $row['id'] . '"><button class="btn btn-sm btn-info"><i class="fa fa-edit"></i> Edit Profile</button></a></td>
                            <td align="center"><a href="admin_transaction?e=' . $row['id'] . '"><button class="btn btn-sm btn-warning"><i class="fa fa-edit"></i> Add Transaction</button></a></td>
                            <td align="center"><a href="admin_change_pic?e=' . $row['id'] . '"><button class="btn btn-sm btn-primary"><i class="fa fa-camera"></i> Change Picture</button></a></td>
                            <td align="center"><a href="admin_delete?e=' . $row['id'] . '"><button class="btn btn-sm btn-danger"><i class="fa fa-eraser"></i> Delete</button></a></td>
                          </tr>
                        ';
                      }
                    } else {
                      echo '
                        <tr>
                          <td colspan="7" class="text-center">0 Records</td>
                        </tr>
                      ';
                    }
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->


    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>

  <!-- Bootstrap core JavaScript-->
  <script src="vendor/jquery/jquery.min.js"></script>
  <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

  <!-- Core plugin JavaScript-->
  <script src="vendor/jquery-easing/jquery.easing.min.js"></script>

  <!-- Custom scripts for all pages-->
  <script src="js/sb-admin-2.min.js"></script>

  <!-- Page level plugins -->
  <script src="vendor/datatables/jquery.dataTables.min.js"></script>
  <script src="vendor/datatables/dataTables.bootstrap4.min.js"></script>

  <!-- Page level custom scripts -->
  <script src="js/demo/datatables-demo.js"></script>

</body>

</html>
