<?php require_once('../../setup.php'); ?>
<?php
session_start();
ob_start();
if (!isset($_SESSION['hash'])) {
  header("Location: login");
  exit();
} else {
  $hash = $_SESSION['hash'];
}
?>
<!DOCTYPE html>
<html lang="en">

<head>

  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">

  <title><?= $main_name; ?></title>

  <!-- Custom fonts for this template-->
  <link rel="shortcut icon" href="../../assets/images/logo.png" />
  <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
  <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

  <!-- Custom styles for this template -->
  <link href="css/sb-admin-2.min.css" rel="stylesheet">

  <!-- Custom styles for this page -->
  <link href="vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">

</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <!-- Sidebar -->
    <?php include('admin_nav.php'); ?>
    <!-- End of Sidebar -->

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar -->
        <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">&nbsp;</nav>
        <!-- End of Topbar -->

        <!-- Begin Page Content -->
        <div class="container-fluid">

          <!-- Page Heading -->
          <h1 class="h3 mb-1 text-primary"><i class="fa fa-user"></i> Edit User Profile</h1>
          <p class="mb-4">You can edit user data by changing the form below.</p>

          <!-- Content Row -->
          <div class="row">

            <!-- Border Left Utilities -->
            <div class="col-lg-6">
              <div class="card mb-4 py-3 border-left-primary">
                <div class="card-body">
                  <?php

                  use PHPMailer\PHPMailer\PHPMailer;

                  require("../conn.php");

                  if (isset($_GET['e'])) {
                    $track_id = $_GET['e'];
                    $sql3 = "SELECT * FROM accounts WHERE id=$track_id";
                    $result3 = $dbconfig->query($sql3);

                    if ($result3->num_rows > 0) {
                      // output data of each row
                      while ($row3 = $result3->fetch_assoc()) {
                        $dbid = $row3['id'];
                        $dbbalance = $row3['balance'];
                        $dbemail = $row3['email'];
                        $dbname = $row3['first_name'];
                        $dbaccount_number = $row3['account_number'];
                        $dbstatus = $row3['status'];
                      }
                    }
                  } else {
                    header("Location: florence");
                  }


                  if (isset($_POST['update_transaction'])) {
                    $from_acc = mysqli_real_escape_string($dbconfig, $_POST['from_acc']);
                    $user_id = mysqli_real_escape_string($dbconfig, $_POST['user_id']);
                    $amount = mysqli_real_escape_string($dbconfig, $_POST['amount']);
                    $account_number = mysqli_real_escape_string($dbconfig, $_POST['account_number']);
                    $account_name = mysqli_real_escape_string($dbconfig, $_POST['account_name']);
                    $bank = mysqli_real_escape_string($dbconfig, $_POST['bank']);
                    $remark = mysqli_real_escape_string($dbconfig, $_POST['remark']);
                    $transaction_id = sha1(rand(1111, 9999) . date('ymdhis'));
                    $status = mysqli_real_escape_string($dbconfig, $_POST['status']);
                    $tag = mysqli_real_escape_string($dbconfig, $_POST['tag']);
                    $date = mysqli_real_escape_string($dbconfig, $_POST['date']);
                    $type = mysqli_real_escape_string($dbconfig, $_POST['type']);

                    $sql = "INSERT INTO transactions (user_id, from_acc, amount, account_number, account_name, bank, remark, transaction_id, status, tag, date, type)
                      VALUES ('$user_id', '$from_acc', '$amount', '$account_number', '$account_name', '$bank', '$remark', '$transaction_id', '$status', '$tag', '$date', '$type')";
                    if ($dbconfig->query($sql) === true) {
                      $sql4 = "SELECT * FROM accounts WHERE account_number='$account_number'";
                      $result4 = $dbconfig->query($sql4);

                      if ($result4->num_rows > 0) {
                        // output data of each row
                        while ($row4 = $result4->fetch_assoc()) {
                          $getbalance = $row4['balance'];
                          $getemail = $row4['email'];
                        }
                      }

                      if ($type == 'Credit') {
                        $new_amount = $getbalance + $amount;
                      } elseif ($type == 'Debit') {
                        $new_amount = $getbalance - $amount;
                      }

                      $sql = "UPDATE accounts SET balance='$new_amount' WHERE account_number='$account_number'";
                      if ($dbconfig->query($sql) === TRUE) {
                        //Send Debit Alert
                        require 'PHPMailer/src/Exception.php';

                        /* The main PHPMailer class. */
                        require 'PHPMailer/src/PHPMailer.php';

                        /* SMTP class, needed if you want to use SMTP. */
                        require 'PHPMailer/src/SMTP.php';

                        $date = date('Y');

                        /* Create a new PHPMailer object. */
                        $mail = new PHPMailer();

                        /* Set the mail sender. */
                        $mail->setFrom($main_email_support, $main_name);

                        /* Add a recipient. */
                        $mail->addAddress($getemail);

                        /* Set the subject. */
                        $mail->Subject = $type . ' Alert!';

                        /* Set the mail message body. */
                        $mail->isHTML(TRUE);
                        $mail->Body = '<html>
                          <head>
                              <meta http-equiv="Content-Type" content="text/html;charset=charset=utf-8" />
                              <title>' . $main_name . '</title>
                              </head>
                              <body>
                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tbody>
                                    <tr>
                                      <td valign="middle" align="center" style="background-color:#333; border-bottom:3px solid #7b59d0;"><h1 style="color:#fff;"><span style="color:#7b59d0; font-weight:bolder;">' . $main_name . '</span></h1></td>
                                    </tr>
                                    <tr>
                                      <td style="background-color:#fff; padding:10px;" align="justify" width="100">
                                        <p>Dear ' . $dbname . ',</p>
                                        <p>We wish to inform you that a ' . $type . ' transaction occurred on your account with us.</p>
                                        <p>The details of this transaction are shown below:</p>
                                        <p><u><b>Transaction Notification</b></u></p>
                                        <table border="0">
                                          <tr>
                                            <td>Account Number</td>
                                            <td>******' . substr($dbaccount_number, -4) . '</td>
                                          </tr>
                                          <tr>
                                            <td>Transaction Location</td>
                                            <td>E-CHANNELS</td>
                                          </tr>
                                          <tr>
                                            <td>Method</td>
                                            <td>FUNDS TRANSFER</td>
                                          </tr>
                                          <tr>
                                            <td>Amount</td>
                                            <td>$' . number_format($amount, 2) . '</td>
                                          </tr>
                                          <tr>
                                            <td>Value Date</td>
                                            <td>' . $date . '</td>
                                          </tr>
                                          <tr>
                                            <td>Description</td>
                                            <td>' . $remark . '</td>
                                          </tr>
                                          <tr>
                                            <td>Current Balance</td>
                                            <td>$' . number_format($new_amount, 2) . '</td>
                                          </tr>
                                          <tr>
                                            <td>Available Balance</td>
                                            <td>$' . number_format($new_amount, 2) . '</td>
                                          </tr>
                                        </table>
                                        <p>The privacy and security of your Bank Account details is important to us.</p>
                                        <p>Thank you for choosing ' . $main_name . ' Bank</p>
                                      </td>
                                    </tr>
                                    <tr>
                                      <td valign="middle" align="center" style="background-color:#333; border-top:3px solid #7b59d0; padding:10px; color:#fff;">© <span style="color: #7b59d0;">' . $main_name . '</span> ' . $date . '.  All Rights Reserved</td>
                                    </tr>
                                  </tbody>
                                </table>
                              </body>
                          </html>';
                        /* Finally send the mail. */
                        if ($mail->send()) {
                          header("Refresh: 2; url=florence");
                          echo '<div align="center" class="alert alert-success"><i class="fa fa-check"></i>&nbsp;&nbsp;<b>Transaction</b> was added successfully...</div>';
                        }
                      }
                    }
                  }
                  ?>
                  <form action="" method="POST">
                    <div class="form-group">
                      <label for="email">From Account Detail:</label>
                      <input type="text" class="form-control" name="from_acc" placeholder="First Name:Account Number" maxlength="100" required>
                      <input type="hidden" class="form-control" name="user_id" value="<?php echo $dbid; ?>" required>
                      <input type="hidden" class="form-control" name="account_number" value="<?php echo $dbaccount_number; ?>" required>
                    </div>
                    <div class="form-group">
                      <label for="email">Bank Name:</label>
                      <input type="text" class="form-control" name="bank" placeholder="eg. <?= $main_name; ?>" maxlength="100" required>
                    </div>
                    <div class="form-group">
                      <label for="email">Account Name:</label>
                      <input type="text" class="form-control" name="account_name" placeholder="eg. James" maxlength="100" required>
                    </div>
                    <div class="form-group">
                      <label for="email">Amount:</label>
                      <input type="number" class="form-control" name="amount" placeholder="eg. 30000" required>
                    </div>
                    <div class="form-group">
                      <label for="email">Remarks:</label>
                      <input type="text" class="form-control" name="remark" placeholder="eg. Purchase Upfront" maxlength="100" required>
                    </div>
                    <div class="form-group">
                      <label for="email">Transaction Status</label>
                      <select class="form-control" name="status" required>
                        <option value="pending">pending</option>
                        <option value="canceled">canceled</option>
                        <option value="approved">approved</option>
                      </select>
                    </div>
                    <div class="form-group">
                      <label for="email">Transaction Tag</label>
                      <select class="form-control" name="tag" required>
                        <option value="same">Same Bank</option>
                        <option value="others">Other Banks</option>
                      </select>
                    </div>
                    <div class="form-group">
                      <label for="email">Transaction Date:</label>
                      <input type="text" class="form-control" name="date" value="<?= date('d-m-Y H:i'); ?>" required>
                    </div>
                    <div class="form-group">
                      <label for="email">Transaction Type</label>
                      <select class="form-control" name="type" required>
                        <option value="Credit">Credit</option>
                        <option value="Debit">Debit</option>
                      </select>
                    </div>
                    <button type="submit" name="update_transaction" class="btn btn-primary">Add Transaction</button>
                  </form>
                </div>
              </div>
            </div>

          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>

  <!-- Bootstrap core JavaScript-->
  <script src="vendor/jquery/jquery.min.js"></script>
  <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

  <!-- Core plugin JavaScript-->
  <script src="vendor/jquery-easing/jquery.easing.min.js"></script>

  <!-- Custom scripts for all pages-->
  <script src="js/sb-admin-2.min.js"></script>

  <!-- Page level plugins -->
  <script src="vendor/datatables/jquery.dataTables.min.js"></script>
  <script src="vendor/datatables/dataTables.bootstrap4.min.js"></script>

  <!-- Page level custom scripts -->
  <script src="js/demo/datatables-demo.js"></script>

</body>

</html>
